	function [Ghp, Zhp, Php] = PZ_2_HP_S(G, Z, P, WI2)
 
	% 	Transforms the poles and zeros of an analog lowpass filter with unity  
	% 	cutoff frequency to a highpass filter using the transformation
	% 
	%  S ->  WI^2/s where WI2 = Wi^2
	
	% Author: 			Oscar Gustafsson 
	% Modified by: 		LW 2003-09-19, 2004-09-22
	% Copyright:		by authors - not released for commercial use
	% Version: 			1
	% Known bugs:		
	% Report bugs to:	Wanhammar@gmail.com

	
	% Transform LP zeros to HP zeros
	for n = 1:length(Z)
		Zhp(n) = WI2/Z(n);
	end
	% Transform LP poles to HP poles
	for n = 1:length(P)
		Php(n) = WI2/P(n);
	end
	% Transform any zeros at infinity for the LP filter
	for n = length(Z)+1:length(P)
		Zhp(n) = 0;
	end
	Zhp = Zhp';
	Php = Php';
	Ghp = 1;
